
set more off

/*=================================================================*/
/*============== Combine Datasets ===========*/
/*=================================================================*/

use "Dataset\ABIII_English.dta", clear
gen wave=3

keep if country==1 | country==5 | country==7 | country==8 | country==10 ///
		| country==15 | country==19 | country==21 | country==22

save "wave3.dta"

use "Dataset\ABII_English.dta", clear
gen wave=2

keep if country==1 | country==5 | country==7 | country==8 | country==10 ///
		| country==15 | country==19 | country==21 | country==22

append using wave3.dta

_strip_labels *




***************************
*** Add Variables ***
***************************

*** Democracy attitudes - Generate DV

gen q512rc=q512
replace q512rc=. if q512==0 | q512==96 | q512==98 | q512==99
gen q5161rc=q5161
replace q5161rc=. if q5161==0 | q5161==8 | q5161==9
gen q5162rc=q5162
replace q5162rc=. if q5162==0 | q5162==8 | q5162==9
gen q5163rc=q5163
replace q5163rc=. if q5163==0 | q5163==8 | q5163==9
gen q5164rc=q5164
recode q5164rc (1=4) (2=3) (3=2) (4=1) (0=.) (5/.=.)
gen q5167rc=q5167
replace q5167rc=. if q5167==0 | q5167==8 | q5167==9
gen q5171rc=q5171
recode q5171rc (1=4) (2=3) (3=2) (4=1) (0=.) (5/.=.)
gen q5172rc=q5172
replace q5172rc=. if q5172==0 | q5172==8 | q5172==9
gen q6071rc=q6071
replace q6071rc=. if q6071==0 | q6071==8 | q6071==9

gen supportdemos=q512
recode supportdemos (0=.) (11/.=.)

gen demosbest=q5164rc
gen demosgood=q5171rc

factor q512rc q5161rc q5162rc q5163rc q5167rc q5172rc q6071rc, pcf
egen demoseffective = rowmean(q5161rc q5162rc q5163rc)

factor q5161rc q5162rc q5163rc q5167rc, pcf
rotate
predict demoseffective1

egen demoseffective2 = rowmean(q5161rc q5162rc q5163rc q5167rc)

gen conseqdemosecon=q5161rc
gen conseqdemosproblems=q5162rc
gen conseqdemosorder=q5163rc
gen conseqdemosvalues=q5167rc
gen conseqdemosprepared=q5165
replace conseqdemosprepared=. if q5165==0 | q5165==8 | q5165==9

* tolerance
gen relgtolerance=q6021
recode relgtolerance (0=.) (1=0) (2=1) (8/.=.)
gen racetolerance=q6022
recode racetolerance (0=.) (1=0) (2=1) (8/.=.)


*** Independent and Control Variables

** 1- Values Systems

* Religion - recoded dummy - 1 is christian, 0 is muslim
gen christian=q1012
recode christian (1=0) (2=1) (0=.) (3/.=.)

* Support for Sharia - recoded - 4 is support for sharia
gen sharia=q6052
recode sharia (0=.) (8/.=.) (4=1) (3=2) (2=3) (1=4)

* Self-Religiosity - recoded - 3 is religious
gen religious=q609
recode religious (1=3) (3=1) (0=.) (8/.=.)

* Pray daily - recoded - 5 is always
gen praydaily=q6101
recode praydaily (1=5) (2=4) (3=3) (4=2) (5=1) (0=.) (8/.=.) 

** 2- Civic Culture

* Interpersonal Trust - recoded dummy - 1 is trustworthy
gen trust=q103
recode trust (0=.) (8/.=.) (1=1) (2=0) 

* Association membership - recoded dummy - 1 is yes
gen membership=q5013
recode membership (2=0) (0=.) (8/.=.)

* Membership in different levels - dummy - 1 is yes
gen membership1=.
replace membership1=1 if q5012==1 | q5013==1 | q5014==1
replace membership1=0 if q5012==2 & q5013==2 & q5014==2

** 3- Modernization

* Income --- are the scales same? there is a huge gap in averages btw waves
gen income=q1014
recode income (0=.) (9999994=0) (9999996=.) (9999998=.) (9999999=.)

* Income Family - 
gen incomefam=q1015
recode incomefam (0=.) (9999994=0) (9999996=.) (9999997=.) (9999998=.) (9999999=.)

* Education - Tunisia and Yemen recoded to match with the rest
gen education=q1003
recode education (0=.) (9=.)
replace education=1 if t1003==1 | q1003t==1 | q1003yem==1
replace education=2 if t1003==2 | q1003t==2 | q1003yem==2
replace education=3 if t1003==3 | q1003t==3 | q1003yem==3  | q1003yem==4
replace education=4 if t1003==4 | q1003t==4 | q1003yem==5
replace education=5 if q1003yem==6
replace education=6 if t1003==5 | q1003t==5 | q1003yem==7
replace education=7 if t1003==6 | q1003t==6 | q1003yem==8

* Urban - recoded dummy - urban is 1
gen urban=q13
recode urban (2=0)

** 4- Political Institutions

* Regime Type - Democracy - dummy - 1 if Egypt or Tunisia
gen democracy=0
replace democracy=1 if country==5 | country==21

* Regime Type - Democracy1 - dummy - 1 if Egypt or Lebanon or Tunisia
gen democracy1=0
replace democracy1=1 if country==5 | country==10 | country==21

* Regime Type - Dictatorship - countries with acting dictators - dummy - 1 if Algeria, Palestine, Jordan, Kuwait, Morocco, Saudi Arabia, Sudan
gen dictatorship=1
replace dictatorship=0 if country==5 | country==7 | country==10 | country==11 | country==21 | country==22

** 5- Political Actors and Events

* Arab Uprisings - dummy - 1 if there was major uprisings
gen uprisings=0
replace uprisings=1 if country==5 | country==11 | country==21 | country==22

* Arab Uprisings1 - ordinal - 1 if minor and 2 if major uprisings
gen uprisings1=0
replace uprisings1=1 if country==1 | country==8 | country==13
replace uprisings1=2 if country==5 | country==11 | country==21 | country==22

* Arab Uprisings2 - dummy - 1 if minor or major uprisings
gen uprisings2=0
replace uprisings2=1 if country==1 | country==5 | country==8 | country==11 | country==13 | country==21 | country==22

* Protest Participation - dummy - 1 if participated once or more + participated against gov't in Egypt or Tunisia
gen protest=q5022
recode protest (1/2=1) (3=0) (0=.) (8/.=.)
replace protest=1 if eg802==1
replace protest=1 if eg802==1 | t902==1
replace protest=0 if eg802==2 | t902==2

* Protest Participation in Uprisings - dummy - 1 if participated ***** Only in Wave 3
gen protestAU=q800a
recode protestAU (2=0) (0=.) (9=.)

* Protest Participation in Uprisings only in Eg and Tun, both waves - dummy, 1 participated
gen protestAUegtun=.
replace protestAUegtun=1 if eg802==1
replace protestAUegtun=0 if eg802==2
replace protestAUegtun=1 if t902==1
replace protestAUegtun=0 if t902==2
replace protestAUegtun=1 if q800a==1 & country==5
replace protestAUegtun=0 if q800a==2 & country==5
replace protestAUegtun=1 if q800a==1 & country==21
replace protestAUegtun=0 if q800a==2 & country==21


** 6- Performance

* Economic Performance - recoded - 4 is very good
gen econperformance=q101
recode econperformance (1=4) (2=3) (3=2) (4=1) (0=.) (8/.=.)

* Future of the Economy - recoded - 5 is hopeful
gen futureecon=q102
recode futureecon (1=5) (2=4) (3=3) (4=2) (5=1) (0=.) (8/.=.)

* Political Performance - recoded - 5 is very good
gen govtperformance=q2031
recode govtperformance (1=5) (2=4) (3=3) (4=2) (5=1) (0=.) (8/.=.)

** 7- Control Variables

* Female - dummy - 1 is female
gen female=q1002
recode female (1=0) (2=1)

* Age
gen age=q1001
recode age (0=.) (990/.=.)

* Age (categorical)
egen agecat=cut(age), at(0, 20, 30, 40, 50, 60, 90)

* Working - dummy - 1 is working
gen working=q1004
recode working (2=0) (0=.) (9=.)


** 8- Country Level Variables

* Polyarchy
generate polyarchy=.
replace polyarchy=0.3838324 if country==5 & wave==2
replace polyarchy=0.28 if country==5 & wave==3
replace polyarchy=0.3024821 if country==22 & wave==2
replace polyarchy=0.45 if country==22 & wave==3
replace polyarchy=0.5296893 if country==7 & wave==2
replace polyarchy=0.52 if country==7 & wave==3
replace polyarchy=0.2952454 if country==8 & wave==2
replace polyarchy=0.3 if country==8 & wave==3
replace polyarchy=0.28 if country==13 & wave==3
replace polyarchy=0.6630512 if country==21 & wave==2
replace polyarchy=0.75 if country==21 & wave==3
replace polyarchy=0.38559 if country==1 & wave==2
replace polyarchy=0.38 if country==1 & wave==3
replace polyarchy=0.5 if country==11 & wave==3
replace polyarchy=0.0262631 if country==17 & wave==2
replace polyarchy=0.62 if country==10 & wave==2
replace polyarchy=0.62 if country==10 & wave==3
replace polyarchy=0.33 if country==15 & wave==2
replace polyarchy=0.33 if country==15 & wave==3
replace polyarchy=0.3 if country==19 & wave==2
replace polyarchy=0.29 if country==19 & wave==3


* Polity
generate polity=.
replace polity=-2 if country==5 & wave==2
replace polity=-2 if country==5 & wave==3
replace polity=-2 if country==22 & wave==2
replace polity=3 if country==22 & wave==3
replace polity=3 if country==7 & wave==2
replace polity=3 if country==7 & wave==3
replace polity=-3 if country==8 & wave==2
replace polity=-3 if country==8 & wave==3
replace polity=-4 if country==13 & wave==3
replace polity=7 if country==21 & wave==2
replace polity=7 if country==21 & wave==3
replace polity=2 if country==1 & wave==2
replace polity=2 if country==1 & wave==3
replace polity=-7 if country==11 & wave==3
replace polity=-10 if country==17 & wave==2
replace polity=-7 if country==9 & wave==3
replace polity=6 if country==10 & wave==2
replace polity=6 if country==10 & wave==3
replace polity=-4 if country==19 & wave==2
replace polity=-4 if country==19 & wave==3


* GDP per capita
generate gdppc=.
replace gdppc=2922.15 if country==5 & wave==2
replace gdppc=3306.13 if country==5 & wave==3
replace gdppc=1460.09 if country==22 & wave==2
replace gdppc=1528.16 if country==22 & wave==3
replace gdppc=3306.15 if country==7 & wave==2
replace gdppc=4113.44 if country==7 & wave==3
replace gdppc=4541.91 if country==8 & wave==2
replace gdppc=5139.26 if country==8 & wave==3
replace gdppc=3555.85 if country==13 & wave==3
replace gdppc=4592.60 if country==21 & wave==2
replace gdppc=5056.13 if country==21 & wave==3
replace gdppc=5000.94 if country==1 & wave==2
replace gdppc=5194.94 if country==1 & wave==3
replace gdppc=11964.73 if country==11 & wave==3
replace gdppc=19890.18 if country==17 & wave==2
replace gdppc=49605.56 if country==9 & wave==3
replace gdppc=10473.64 if country==10 & wave==2
replace gdppc=11880.63 if country==10 & wave==3
replace gdppc=2900 if country==15 & wave==2
replace gdppc=2900 if country==15 & wave==3
replace gdppc=1938.96 if country==19 & wave==2
replace gdppc=1739.41 if country==19 & wave==3


* GDP Growth
generate gdpgrowth=.
replace gdpgrowth=1.217 if country==5 & wave==2
replace gdpgrowth=4.009 if country==5 & wave==3
replace gdpgrowth=-2.47 if country==22 & wave==2
replace gdpgrowth=2.192 if country==22 & wave==3
replace gdpgrowth=9.648 if country==7 & wave==2
replace gdpgrowth=10.236 if country==7 & wave==3
replace gdpgrowth=2.311 if country==8 & wave==2
replace gdpgrowth=3.45 if country==8 & wave==3
replace gdpgrowth=4.869 if country==13 & wave==3
replace gdpgrowth=0.007 if country==21 & wave==2
replace gdpgrowth=5.229 if country==21 & wave==3
replace gdpgrowth=2.855 if country==1 & wave==2
replace gdpgrowth=3.36 if country==1 & wave==3
replace gdpgrowth=4.164 if country==11 & wave==3
replace gdpgrowth=6.471 if country==17 & wave==2
replace gdpgrowth=4.775 if country==9 & wave==3
replace gdpgrowth=1.5 if country==10 & wave==2
replace gdpgrowth=4 if country==10 & wave==3
replace gdpgrowth=2.3 if country==15 & wave==2
replace gdpgrowth=14.3 if country==15 & wave==3
replace gdpgrowth=-0.224 if country==19 & wave==2
replace gdpgrowth=3.068 if country==19 & wave==3


* Unemployment
generate unemployment=.
replace unemployment=10.405 if country==5 & wave==2
replace unemployment=11.305 if country==5 & wave==3
replace unemployment=29 if country==22 & wave==2
replace unemployment=23.5 if country==22 & wave==3
replace unemployment=15.2 if country==7 & wave==2
replace unemployment=15.1 if country==7 & wave==3
replace unemployment=12.5 if country==8 & wave==2
replace unemployment=12.5 if country==8 & wave==3
replace unemployment=8.8 if country==13 & wave==3
replace unemployment=14.7 if country==21 & wave==2
replace unemployment=14 if country==21 & wave==3
replace unemployment=9.79 if country==1 & wave==2
replace unemployment=9.15 if country==1 & wave==3
replace unemployment=17.2 if country==11 & wave==3
replace unemployment=5.7 if country==17 & wave==2
replace unemployment=2.072 if country==9 & wave==3
replace unemployment=6.19 if country==10 & wave==2
replace unemployment=6.2 if country==10 & wave==3
replace unemployment=25 if country==15 & wave==2
replace unemployment=22 if country==15 & wave==3
replace unemployment=13.41 if country==19 & wave==2
replace unemployment=11.03 if country==19 & wave==3


* Population
generate population=.
replace population=79300000 if country==5 & wave==2
replace population=82500000 if country==5 & wave==3
replace population=25130000 if country==22 & wave==2
replace population=26660000 if country==22 & wave==3
replace population=32840000 if country==7 & wave==2
replace population=34409000 if country==7 & wave==3
replace population=6253000 if country==8 & wave==2
replace population=6544000 if country==8 & wave==3
replace population=32853000 if country==13 & wave==3
replace population=10655000 if country==21 & wave==2
replace population=10879000 if country==21 & wave==3
replace population=36676000 if country==1 & wave==2
replace population=37785000 if country==1 & wave==3
replace population=6202000 if country==11 & wave==3
replace population=28169000 if country==17 & wave==2
replace population=3999000 if country==9 & wave==3
replace population=3958000 if country==10 & wave==2
replace population=4062000 if country==10 & wave==3
replace population=3531000 if country==15 & wave==2
replace population=3531000 if country==15 & wave==3
replace population=32661000 if country==19 & wave==2
replace population=34382000 if country==19 & wave==3


* log(Population)
generate logpop = log(population)


* Muslim Share in Population
generate muslimshare=.
replace muslimshare=90 if country==5 & wave==2
replace muslimshare=90 if country==5 & wave==3
replace muslimshare=99 if country==22 & wave==2
replace muslimshare=99 if country==22 & wave==3
replace muslimshare=99 if country==7 & wave==2
replace muslimshare=99 if country==7 & wave==3
replace muslimshare=97.2 if country==8 & wave==2
replace muslimshare=97.2 if country==8 & wave==3
replace muslimshare=99 if country==13 & wave==3
replace muslimshare=99 if country==21 & wave==2
replace muslimshare=99 if country==21 & wave==3
replace muslimshare=99 if country==1 & wave==2
replace muslimshare=99 if country==1 & wave==3
replace muslimshare=96.6 if country==11 & wave==3
replace muslimshare=99 if country==17 & wave==2
replace muslimshare=76.7 if country==9 & wave==3
replace muslimshare=54 if country==10 & wave==2
replace muslimshare=54 if country==10 & wave==3
replace muslimshare=80 if country==15 & wave==2
replace muslimshare=80 if country==15 & wave==3
replace muslimshare=97 if country==19 & wave==2
replace muslimshare=97 if country==19 & wave==3


** Additional Variables

* safety
gen safety=q105
recode safety (1=4) (2=3) (3=2) (4=1) (0=.) (8/.=.)

* gradual change
gen gradual=q514
recode gradual (1=4) (2=3) (3=2) (4=1) (0=.) (7/.=.)

* treatequally
gen treatequally=q106
recode treatequally (1=4) (2=3) (3=2) (4=1) (0=.) (8/.=.)

* political interst
recode q404 (0=.) (1=4) (2=3) (3=2) (4=1) (8/.=.), gen(polsinterest)

* follownews
recode q405 (0=.) (1=4) (2=3) (3=2) (4=1) (8/.=.), gen(follownews)

* follow news from different sources
recode q4061 (0=.) (1=5) (2=4) (3=3) (4=2) (5=1) (8/.=.), gen(follownewstv)
recode q4062 (0=.) (1=5) (2=4) (3=3) (4=2) (5=1) (8/.=.), gen(follownewspress)
recode q4064 (0=.) (1=5) (2=4) (3=3) (4=2) (5=1) (8/.=.), gen(follownewsradio)
recode q4065 (0=.) (1=5) (2=4) (3=3) (4=2) (5=1) (8/.=.), gen(followinternet)

* internet usage
recode q409 (0=.) (1=5) (2=4) (3=3) (4=2) (5=1) (8/.=.), gen(internetuse)

* emigrate
recode q104 (0=.) (1/4=1) (5=0) (6/99994=1) (99998/.=2) (5=1) (8/.=.), gen(emigrate)

* institutional trust
recode q2011 (0=.) (1=4) (2=3) (3=2) (4=1) (8/.=.), gen(trustgovt)
recode q2014 (0=.) (1=4) (2=3) (3=2) (4=1) (8/.=.), gen(trustpolice)
recode q2016 (0=.) (1=4) (2=3) (3=2) (4=1) (8/.=.), gen(trustarmy)
recode q2017 (0=.) (1=4) (2=3) (3=2) (4=1) (8/.=.), gen(trustcso)

* corruption
recode q210 (0=.) (1=1) (2=0) (8/.=.), gen(corruption)
recode q211 (0=.) (1=4) (2=3) (3=2) (4=1) (8/.=.), gen(fightcorruption)

* government satisfaction
recode q513 (0=.) (95/.=.), gen(govtsatisfaction)

* visited west?
recode q702 (0=.) (5=0) (8/.=.), gen(visitwest)

* egypt-leb-tun-yem
generate eglbtnyem=0
replace eglbtnyem=1 if country==5
replace eglbtnyem=1 if country==10
replace eglbtnyem=1 if country==21
replace eglbtnyem=1 if country==22

erase "wave3.dta"
save "Arab Barometer IRT.dta", replace


set more off

import delimited "1. IRT Calculation 2,3\Theta Statistics.csv", colrange(2:2) clear

merge 1:1 _n using "Arab Barometer IRT.dta"

rename mean irtsupport
save "Arab Barometer IRT.dta", replace
